% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{quantile.Exponential}
\alias{quantile.Exponential}
\title{Determine quantiles of a Exponential distribution}
\usage{
\method{quantile}{Exponential}(d, p, ...)
}
\arguments{
\item{d}{A \code{Exponential} object created by a call to \code{\link[=Exponential]{Exponential()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Exponential(5)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
