% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dip5}
\alias{dip5}
\title{Fluid weights of drink cans}
\format{
A data frame with 100 observations and 3 variables:
  \describe{
  \item{type}{Factor with the single level \code{reference}}
  \item{batch}{Factor with levels \code{b1} to \code{b100}}
  \item{weight}{Weight of drink cans}
}
}
\source{
See reference: Chapter 5 (The CAPABILITY Procedure), Cans data set shown
on page 199.
}
\usage{
data(dip5)
}
\description{
The \code{response} values of this data set correspond to the values
  published in the SAS/QC(R) 13.1 (2013) User's Guide, Chapter 5 (The
  CAPABILITY Procedure). The data set is described on page 199: The fluid
  weights of 100 drink cans were measured in ounces. The filling process is
  assumed to be in statistical control.
}
\examples{
str(dip5)
}
\references{
SAS Institute Inc. 2013. \emph{SAS/QC(R) 13.1 User's Guide}. Cary, NC:
SAS Institute Inc.\cr
\url{https://support.sas.com/documentation/cdl/en/qcug/66857/PDF/
default/qcug.pdf}
}
\keyword{datasets}
