% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinsim1.R
\name{kinsim1}
\alias{kinsim1}
\title{Simulate Biometrically informed Univariate Data}
\usage{
kinsim1(r = c(1, 0.5), npg = 100, npergroup = rep(npg, length(r)),
  mu = 0, ace = c(1, 1, 1), r_vector = NULL, ...)
}
\arguments{
\item{r}{Levels of relatedness; default is MZ and DZ twins c(1,.5)}

\item{npg}{Sample size per group; default is 100.}

\item{npergroup}{List of sample sizes by group; default repeats \code{npg} for all groups.}

\item{mu}{Mean for generated variable; default is 0.}

\item{ace}{Vector of variance components, ordered by c(a, c, e); default is c(1,1,1).}

\item{r_vector}{Alternative, give vector of relatedness cofficients for entire sample.}

\item{...}{further arguments passed to or from other methods}
}
\value{
Returns \code{data.frame} with the following:
\item{id}{id}
\item{A1}{genetic component for kin1}
\item{A2}{genetic component for kin2}
\item{C1}{shared-environmental component for kin1}
\item{C2}{shared-environmental component for kin2}
\item{E1}{non-shared-environmental component for kin1}
\item{E2}{non-shared-environmental component for kin2}
\item{y1}{generated variable for kin1 with mean of \code{mu}}
\item{y2}{generated variable for kin2 with mean of \code{mu}}
\item{r}{level of relatedness for the kin pair}
}
\description{
Generate paired univariate data, given ACE parameters.
}
