% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broadcast.R
\name{broadcast}
\alias{broadcast}
\alias{broadcast.default}
\alias{broadcast.ddf_col}
\alias{broadcast.tbl_ddf}
\title{Broadcast to a new dimension}
\usage{
broadcast(x, dim_names = NULL, ...)

\method{broadcast}{default}(x, dim_names = NULL, ...)

\method{broadcast}{ddf_col}(x, dim_names, ...)

\method{broadcast}{tbl_ddf}(x, dim_names, ...)
}
\arguments{
\item{x}{A dibble, vector, or array.}

\item{dim_names}{A character vector or list of dimension names.}

\item{...}{Unused, for extensibility.}
}
\value{
A dibble.
}
\description{
Broadcasts the dimension of the object to a new dimension.
}
\details{
Operations between dibbles are automatically broadcasted, but for safety
reasons, warnings are issued.
\code{broadcast()} can suppress the warnings if \code{dim_names} matches the dimension
of \code{x}.
}
\examples{
x <- broadcast(1:2,
               list(axis1 = letters[1:2]))
y <- broadcast(1:3,
               list(axis2 = letters[1:3]))
broadcast(x * y, c("axis1", "axis2"))

}
