% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.char.seed.R
\name{set.char.seed}
\alias{set.char.seed}
\title{Convert any character vector to an integer for setting a reproducible seed}
\usage{
set.char.seed(char)
}
\arguments{
\item{char}{a character vector}
}
\value{
\code{set.char.seed()} takes a character vector and returns a reproducible seed.
}
\description{
\code{set.char.seed()} converts a character vector into an integer used as reproducible
seed
}
\details{
Each letter and number in the character vector is assigned a specific number. These
numbers are concatenated and divided by 2^30 - 1, and the remainder of this division
is used as the numeric reproducible seed.

If you get a warning about 'loss of accuracy", consider using a more succinct character
vector, otherwise you will get a seed of 0.
}
\examples{
set.char.seed("The Sticky Chicken")
set.char.seed("lanky tadpole")
set.char.seed("Manny said what?")


}
\author{
JP Monteagudo
}
\keyword{internals}
