% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desirability.R
\name{desirability}
\alias{desirability}
\title{High-level interface to specifying desirability functions}
\usage{
desirability(..., .use_data = FALSE)
}
\arguments{
\item{...}{using a goal function (see below) and the variable to be
optimized. Other arguments should be specified as needed but \strong{must be
named}. Order of the arguments does not matter.}

\item{.use_data}{A single logical to specify whether all translated
desirability functions (such as \code{\link[=d_max]{d_max()}}) should enable \code{use_data = TRUE} to
fill in any unspecified required arguments.}
}
\value{
An object of class \code{"desirability_set"} that can be used to make
a set of desirability functions.
}
\description{
High-level interface to specifying desirability functions
}
\details{
The following set of nonexistent functions are used to specify an
optimization goal:
\itemize{
\item \code{maximize()} (corresponding to  \code{\link[=d_max]{d_max()}})
\item \code{minimize()}  (\code{\link[=d_min]{d_min()}})
\item \code{target()} (\code{\link[=d_target]{d_target()}})
\item \code{constrain()} (\code{\link[=d_box]{d_box()}})
\item \code{categories()} (\code{\link[=d_max]{d_max()}})
}

For example, if you wanted to jointly maximize a regression model’s Rsquared
while minimizing the RMSE, you could use

\preformatted{
  desirability(
    minimize(rmse, scale = 3),
    maximize(rsq)
 )
}

Where the \code{scale} argument makes the desirability curve more stringent.
}
\keyword{internal}
