% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install Dependencies}
\usage{
install(
  dir = getwd(),
  file = "dependencies.json",
  upgrade = "never",
  cleanup = TRUE,
  timeout = 300L,
  ask = TRUE,
  ...
)
}
\arguments{
\item{dir}{Path to the directory where the JSON file should be written to.}

\item{file}{The name of the file to be save, default is \code{"dependencies.json"}. If the file is not found in \code{dir}, \code{create()} is called.}

\item{upgrade}{Should package dependencies be upgraded? Argument passed to remotes functions.}

\item{cleanup}{Logical, clean up files created by \code{create()} when \code{file} does not exist.}

\item{timeout}{Integer, timeout for file downloads (default 60 seconds can be short).}

\item{ask}{Logical, asking confirmation before writing the \code{dependencies.json} file.}

\item{...}{Other argument passed to remotes functions.}
}
\value{
Returns \code{NULL} invisibly. The side effect is the dependencies installed.
}
\description{
Install dependencies from an existing \code{dependencies.json} file or after discovering the dependencies.
}
\examples{
dir <- system.file("examples/01-basic", package = "deps")
out <- tempdir()
create(dir, output = out, ask = interactive())
cat(readLines(file.path(out, "dependencies.json")), sep = "\n")
\dontrun{
install(out)
}
unlink(file.path(out, "dependencies.json"))

}
