% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{basal}
\alias{basal}
\title{The basal area of stands}
\usage{
basal(
  dbh,
  area,
  factor1 = "",
  factor2 = "",
  factor3 = "",
  data,
  constant = 100
)
}
\arguments{
\item{dbh}{numeric vector of diameter. If \code{data} is specified, character indicating name of variable of \code{data} containing dbh values.}

\item{area}{numeric, area of a plot (see \code{details} for unit).}

\item{factor1, factor2, factor3}{character, optional variables of the data frame that define subsets to consider.}

\item{data}{data frame containing optional factors \code{factor1,factor2,factor3}.}

\item{constant}{numeric, used to convert diameter unit. Default is \code{100} (see \code{details})}
}
\value{
A vector of basal area of stands. If more than one factor set, a list.
}
\description{
The basal area is the cross sectional area of the bole or stem of a tree at breast height.
}
\details{
If \code{area} is expressed in ha and \code{dbh} expressed in cm, the basal area unit is cm²/ha when \code{constant = 1}.
In order to convert centimeter (cm) to meter (m) for \code{dbh}, set \code{constant = 100}. Because 1m = 100 cm. Then, basal area unit will be \code{m²/ha}.

If \code{dbh} is in meter (m), and \code{area} in in hectare (ha), setting \code{constant = 1} returns basal area in m²/ha.

If \code{dbh} is in feet, and \code{area} in acre, setting \code{constant = 1} returns basal area in ft²/ac.

If \code{dbh} is in inch, and \code{area} in acre, setting \code{constant = 12} returns basal area in feet²/acres (ft²/ac).
}
