% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorrelate.R
\name{decorrelate}
\alias{decorrelate}
\title{Decorrelation projection}
\usage{
decorrelate(X, ecl, lambda, transpose = FALSE, alpha = -1/2)
}
\arguments{
\item{X}{matrix to be transformed so *columns* are independent}

\item{ecl}{estimate of covariance/correlation matrix from \link{eclairs} storing \eqn{U}, \eqn{d_1^2}, \eqn{\lambda} and \eqn{\nu}}

\item{lambda}{specify lambda and override value from \code{ecl}}

\item{transpose}{logical, (default FALSE) indicating if X should be transposed first}

\item{alpha}{default = -1/2.  Exponent of eigen-values}
}
\value{
a matrix following the decorrelation transformation
}
\description{
Efficient decorrelation projection using \link{eclairs} decomposition
}
\details{
Apply a decorrelation transform using the implicit covariance approach to avoid directly evaluating the covariance matrix
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)

# eclairs decomposition
ecl <- eclairs(Y)

# whitened Y
Y.transform <- decorrelate(Y, ecl)
#
}
