% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbflob.R
\name{read_flob}
\alias{read_flob}
\title{Read flob}
\usage{
read_flob(column_name, table_name, key, conn, slob = FALSE)
}
\arguments{
\item{column_name}{A string of the name of the BLOB column.}

\item{table_name}{A string of the name of the existing table.}

\item{key}{A data.frame whose columns and values are used to filter the
table to a single row (this in combination with the \code{column_name}
argument are used to target a single cell within the table to modify).}

\item{conn}{A SQLite connection object.}

\item{slob}{A logical scalar specifying whether to process as slobs (serialized blobs) instead of flobs.
If NA, the function will adapt accordingly.}
}
\value{
A flob or blob.
}
\description{
Read a \code{\link[flobr]{flob}} from a SQLite database.
}
\examples{
flob <- flobr::flob_obj
conn <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbWriteTable(conn, "Table1", data.frame(IntColumn = c(1L, 2L)))
key <- data.frame(IntColumn = 2L)
write_flob(flob, "BlobColumn", "Table1", key, conn, exists = FALSE)
read_flob("BlobColumn", "Table1", key, conn)
DBI::dbDisconnect(conn)
}
