% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_site.R
\name{build_site}
\alias{build_site}
\title{Build a dataspice site}
\usage{
build_site(
  path = "data/metadata/dataspice.json",
  template_path = system.file("template.html5", package = "dataspice"),
  out_path = "docs/index.html"
)
}
\arguments{
\item{path}{(character) Path to a JSON+LD file with dataspice metadata}

\item{template_path}{(character) Optional. Path to a template for \code{\link[whisker]{whisker.render}}}

\item{out_path}{(character) Optional. Path to write the site's \code{index.html}
to. Defaults to \code{docs/index.html}.}
}
\value{
Nothing. Creates/overwrites \code{docs/index.html}
}
\description{
Build a dataspice site
}
\examples{
\dontrun{
# Create JSON+LD from a set of metadata templates
json <- write_json(biblio, access, attributes, creators)
build_site(json)
}
}
