% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_check_meta_data_dataframe.R
\name{prep_check_meta_data_dataframe}
\alias{prep_check_meta_data_dataframe}
\title{Verify and normalize metadata on data frame level}
\usage{
prep_check_meta_data_dataframe(
  meta_data_dataframe = "dataframe_level",
  meta_data_v2,
  dataframe_level
)
}
\arguments{
\item{meta_data_dataframe}{\link{data.frame} data frame or path/url of a metadata
sheet for the data frame level}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{dataframe_level}{\link{data.frame} alias for \code{meta_data_dataframe}}
}
\value{
standardized metadata sheet as data frame
}
\description{
if possible, mismatching data types are converted (\code{"true"} becomes \code{TRUE})
}
\details{
missing columns are added, filled with \code{NA}, if this is valid, i.e., n.a.
for \code{DF_NAME} as the key column
}
\examples{
\dontrun{
mds <- prep_check_meta_data_dataframe("ship_meta_dataframe|dataframe_level") # also converts
print(mds)
prep_check_meta_data_dataframe(mds)
mds1 <- mds
mds1$DF_RECORD_COUNT <- NULL
print(prep_check_meta_data_dataframe(mds1)) # fixes the missing column by NAs
mds1 <- mds
mds1$DF_UNIQUE_ROWS[[2]] <- "xxx" # not convertible
# print(prep_check_meta_data_dataframe(mds1)) # fail
mds1 <- mds
mds1$DF_UNIQUE_ID[[2]] <- 12
# print(prep_check_meta_data_dataframe(mds1)) # fail
}
}
