% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\name{createObject}
\alias{createObject}
\alias{createObject,MNode-method}
\title{Create an object on a Member Node.}
\usage{
createObject(x, ...)

\S4method{createObject}{MNode}(x, pid, file = as.character(NA), sysmeta, dataobj = NULL, ...)
}
\arguments{
\item{x}{The MNode instance on which the object will be created}

\item{...}{(Not yet used.)}

\item{pid}{The identifier of the object to be created}

\item{file}{the absolute file location of the object to be uploaded}

\item{sysmeta}{a SystemMetadata instance describing properties of the object}

\item{dataobj}{a \code{raw} object to use for the upload, instead of the contents of the \code{file} argument.}
}
\value{
a \code{character} containing the identifier that was created.
}
\description{
This method provides the ability to upload a data or metadata object to the Member Node
provided in the \code{'mnode'} parameter.
}
\details{
In the version 2.0 library and higher, this operation can utilize an 
'dataone_token' option to provide credentials for write operations in DataONE.
The authentication token is obtained from DataONE (see your profile on https://search.dataone.org).
See the \code{vignette("dataone-overview")} for details.
Alternatively, the version 1.0 approach of using an X.509 certificate in a default location of the file 
system can also be used. This certificate provides authentication credentials from 
CILogon \url{https://cilogon.org/?skin=DataONE}.  See \code{vignette("dataone-overview")} for details.
}
\examples{
\dontrun{
# Create an object in the DataONE "STAGING" environment
library(dataone)
library(uuid)
library(digest)
library(datapack)
cn <- CNode("STAGING")
mn <- getMNode(cn, "urn:node:mnStageUCSB2")
# Have Dataone create an identifier for you (requires authentication)
\dontrun{
newid <- generateIdentifier(mn, "UUID")
}
# Create an identifier manually
newid <- paste("urn:uuid:", UUIDgenerate(), sep="") 
testdf <- data.frame(x=1:10,y=11:20)
csvfile <- paste(tempfile(), ".csv", sep="")
write.csv(testdf, csvfile, row.names=FALSE)
format <- "text/csv"
size <- file.info(csvfile)$size
sha1 <- digest(csvfile, algo="sha1", serialize=FALSE, file=TRUE)
sysmeta <- new("SystemMetadata", identifier=newid, formatId=format, size=size, checksum=sha1)
sysmeta <- addAccessRule(sysmeta, "public", "read")
# Upload the data to DataONE (requires authentication)
\dontrun{
createObject(mn, newid, csvfile, sysmeta)
}
}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MNStorage.create}
}
