% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R
\docType{class}
\name{CNode-class}
\alias{CNode-class}
\title{Provides R API to DataONE Coordinating Node services.}
\description{
The CNode class provides methods that interact with a DataONE Coordinating Node.
}
\section{Slots}{

\describe{
\item{\code{endpoint}}{A character vector containing URL service endpoint for the Coordinating Node}

\item{\code{services}}{A data.frame containing the supported service tiers for a CN}

\item{\code{serviceUrls}}{A data.frame contains URL endpoints for certain services}
}}
\section{Methods}{

\itemize{
 \item{\code{\link{CNode}}}{: Construct a CNode object.}
 \item{\code{\link{listFormats}}}{: List all object formats registered in DataONE.}
 \item{\code{\link{getFormat}}}{: Get information for a single DataONE object format } 
 \item{\code{\link{getChecksum}}}{: Get the checksum for the data object associated with the specified pid.}
 \item{\code{\link{listNodes}}}{: Get the list of nodes associated with a CN.} 
 \item{\code{\link{reserveIdentifier}}}{: Reserve a identifier that is unique in the DataONE network.}
 \item{\code{\link{hasReservation}}}{: Checks to determine if the supplied subject is the owner of the reservation of id.}
 \item{\code{\link{setObsoletedBy}}}{: Set a pid as being obsoleted by another pid}
 \item{\code{\link{getObject}}}{: Get the bytes associated with an object on this Coordinating Node.} 
 \item{\code{\link{getSystemMetadata}}}{: Get the bytes associated with an object on this Coordinating Node.}
 \item{\code{\link{describeObject}}}{: Get a list of coordinating nodes holding a given pid.} 
 \item{\code{\link{resolve}}}{: Get a list of coordinating nodes holding a given pid.}
 \item{\code{\link{getMNode}}}{: Get a reference to a node based on its identifier.} 
 \item{\code{\link{echoCredentials}}}{: Echo the credentials used to make the call.} 
 \item{\code{\link{isAuthorized}}}{: Check if an action is authorized for the specified identifier.} 
}
}
\seealso{
\code{\link{dataone}}{ package description.}
}

