% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\docType{class}
\name{D1Node-class}
\alias{D1Node-class}
\title{A base class for CNode and MNode.}
\description{
D1Node is a base class for CNode and MNode classes and contains class slots and
methods that are common between these two child classes.
}
\section{Slots}{

\describe{
\item{\code{identifier}}{The node identifier of the MN}

\item{\code{name}}{The node name}

\item{\code{description}}{The node description}

\item{\code{baseURL}}{The registered baseURL for the node, which does not include the version string}

\item{\code{subject}}{The Distinguished Name of this node, used for authentication}

\item{\code{contactSubject}}{The Distinguished Name of contact person for this node}

\item{\code{replicate}}{a logical flag indicating whether the node accepts replicas}

\item{\code{type}}{the node type, either 'mn' or 'cn'}

\item{\code{state}}{an indication of whether the node is accessible, either 'up' or 'down'}

\item{\code{services}}{A data.frame containing the service tiers supported by this node.}

\item{\code{serviceUrls}}{a data.frame that contains DataONE service Urls}

\item{\code{APIversion}}{The version of the DataONE API for this node}

\item{\code{env}}{a character string, either 'prod' if this node is in the production environment, otherwise 'test'}
}}
\section{Methods}{

\itemize{
 \item{\code{\link{D1Node-initialize}{initialize}}}{: Initialize a D1Node}
 \item{\code{\link{D1Node}}}{: Create a MNode object representing a DataONE Member Node repository.}
 \item{\code{\link{archive}}}{: Create an object on a Member Node.}
 \item{\code{\link{describeObject}}}{: Get header information for a given pid.} 
 \item{\code{\link{get}}}{: Get the bytes associated with an object on a node.}
 \item{\code{\link{getQueryEngineDescription}}}{: Get the node capabilities description, and store the information in the MNode.}
 \item{\code{\link{listObjects}}}{: Get a unique identifier that is generated by the Member Node repository and guaranteed to be unique.}
 \item{\code{\link{listQueryEngines}}}{: Get a unique identifier that is generated by the Member Node repository and guaranteed to be unique.}
 \item{\code{\link{ping}}}{: Download a data package from a member node.}
 \item{\code{\link{encodeSolr}}}{: Update an object on a Member Node, by creating a new object that replaces an original.}
 \item{\code{\link{query}}}{: Update the system metadata associated with an object.}
}
}

