% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDataDatana.r
\docType{data}
\name{ChickWeight}
\alias{ChickWeight}
\title{Chicken growth data -- kept it only for the book.}
\format{
Contains four variables, as follows:
\describe{
  \item{weight}{A numeric vector giving the body weight of the chick (gm).}
  \item{Time}{A numeric vector giving the number of days since birth when 
  the measurement was made.}
\item{Chick}{An ordered factor with levels different giving a unique 
identifier for the chick. The ordering of the
            levels groups chicks on the same diet together and orders
             them according to their final weight 
            (lightest to heaviest) within diet.}
\item{Diet}{A factor with levels 1,2,3 and 4 indicating which experimental 
diet the chick received.}
 }
}
\source{
See related-details on this, for the dataframe "chicksw".
}
\usage{
data(ChickWeight)
}
\description{
These data are the same as in the 'chicksw' dataframe, which
is the one that should be preferred. Nonetheless, I kept the name of this
dataframe (i.e., ChickWeight) to be able for using in the book of
 Salas-Eljatib (2021).
Further details of the dataframe can be found by typing "?chicksw"
}
\examples{
data(ChickWeight)    
head(ChickWeight) 
}
\references{
- Salas-Eljatib, C. 2021. Análisis de datos con el programa estadístico R:
 una introducción
 aplicada. Ediciones Universidad Mayor, Santiago, Chile. 170 p.
  \url{https://eljatib.com/rlibro}
}
\keyword{datasets}
