% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explorer.R
\name{explorer}
\alias{explorer}
\title{Create an interactive codebook explorer}
\usage{
explorer(data = NULL, addEnv = TRUE, demo = FALSE)
}
\arguments{
\item{data}{A list of (optionally named) data frames. Also accepts a character vector of data frame names (must be loaded in environment).}

\item{addEnv}{Logical. Indicates whether to add all data frames in current environemnt to explorer. Defaults to \code{addEnv=TRUE}.}

\item{demo}{Logical. Indicates whether to display demo data frames.  If \code{TRUE}, \code{dataList} and \code{addEnv} settings will be ignored.  Defaults to \code{demo=FALSE}.}
}
\description{
This function produces an interactive codebook explorer using R htmlwidgets.
The interactive codebook explorer allows the user to explore multiple data frames within 
the RStudio viewer or a web browser.  The explorer can also be embedded in an R Markdown document or 
saved as a standalone HTML page.
}
\examples{
### Generate explorer using all data loaded into R session (default).
explorer(data = NULL, addEnv = TRUE)

### Provide a list of (optionally named) data frames.
explorer(data = list(Cars = mtcars, Iris = iris))

### Alternatively, provide data frames currently loaded in R session as a character vector.
explorer(data = c("mtcars","iris"))

### Generate explorer using data from the datasets package.
explorer(demo = TRUE)


}
\seealso{
codebook
}
