% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googleFinanceData.R
\name{googleFinanceData}
\alias{googleFinanceData}
\title{Historical Price Data Download from Google Finance}
\usage{
googleFinanceData(sym, current = TRUE, sy = 2005, sm = 1, sd = 1, ey,
  em, ed)
}
\arguments{
\item{sym}{A character string for a (tradeable) symbol}

\item{current}{A logical switch to indicate whether the current time is the endtime}

\item{sy}{An integer value for the start year, default is 2005}

\item{sm}{An integer value for the start month, default is 1}

\item{sd}{An integer value for the start date, default is 1}

\item{ey}{An optional integer value for the end year, required if \code{current} is false}

\item{em}{An optional integer value for the end month, required if \code{current} is false}

\item{ed}{An optional integer value for the end day, required if \code{current} is false}
}
\value{
A \code{data.table} object with a key on \code{date}
}
\description{
Download historical time series from Google Finance
}
\details{
The function uses an (unofficial) older CGI-style interface at
Google to download historical data.
}
\seealso{
The post at
\url{https://web.archive.org/web/20221007040328/https://chrisconlan.com/download-historical-stock-data-google-r-python/}
provided the initial starting point
}
\author{
Dirk Eddelbuettel
}
