% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001_api.R
\name{load}
\alias{load}
\title{Loading data with dabestr}
\usage{
load(
  data,
  x,
  y,
  idx = NULL,
  paired = NULL,
  id_col = NULL,
  ci = 95,
  resamples = 5000,
  colour = NULL,
  proportional = FALSE,
  minimeta = FALSE,
  delta2 = FALSE,
  experiment = NULL,
  experiment_label = NULL,
  x1_level = NULL
)
}
\arguments{
\item{data}{A tidy dataframe.}

\item{x}{Column in \code{data} that contains the treatment groups.}

\item{y}{Column in \code{data} that contains the measurement values.}

\item{idx}{List of control-test groupings for which the
effect size will be computed for.}

\item{paired}{Paired ("sequential" or "baseline"). Used for plots for experiments
with repeated-measures designs.

If "sequential", comparison happens between each measurement to the one directly
preceding it. (control vs group i)

If "baseline", comparison happens between each group to a shared control.
(group i vs group i+1)}

\item{id_col}{Column in \code{data} indicating the identity of the
datapoint if the data is tagged. Compulsory parameter if paired is TRUE.}

\item{ci}{Default 95. Determines the range of the confidence interval for effect size
and bootstrap calculations. Only accepts values between 0 to 100 (inclusive).}

\item{resamples}{The number of resamples to be used to generate the effect size bootstraps.}

\item{colour}{Column in \code{data} that determines the groupings for colour of the
swarmplot as opposed to \code{x}.}

\item{proportional}{Boolean value determining if proportion plots are being
produced.}

\item{minimeta}{Boolean value determining if mini-meta analysis is conducted.}

\item{delta2}{Boolean value determining if delta-delta analysis for
2 by 2 experimental designs is conducted.}

\item{experiment}{Experiment column name for delta-delta analysis.}

\item{experiment_label}{String specifying the experiment label that is used to
distinguish the experiment and the factors (being used in the plotting labels).}

\item{x1_level}{String setting the first factor level in
a 2 by 2 experimental design.}
}
\value{
Returns a \code{dabest_obj} list with 18 elements. The following are the elements contained within:
\itemize{
\item \code{raw_data} The tidy dataset passed to \code{\link[=load]{load()}} that was cleaned and altered for plotting.
\item \code{proportional_data} List of calculations related to the plotting of proportion plots.
\item \code{enquo_x}  Quosure of x as initially passed to \code{\link[=load]{load()}}.
\item \code{enquo_y}  Quosure of y as initially passed to \code{\link[=load]{load()}}.
\item \code{enquo_id_col} Quosure of id_col as initially passed to \code{\link[=load]{load()}}.
\item \code{enquo_colour} Quosure of colour as initially passed to \code{\link[=load]{load()}}.
\item \code{proportional} Boolean value determining if proportion plots are being
produced.
\item \code{minimeta} Boolean value determining if mini-meta analysis is conducted.
\item \code{delta2} Boolean value determining if delta-delta analysis for
2 by 2 experimental designs is conducted.
\item \code{idx} List of control-test groupings for which the
effect size will be computed for.
\item \code{resamples} The number of resamples to be used to generate the effect size bootstraps.
\item \code{is_paired} Boolean value determining if it is a paired plot.
\item \code{is_colour} Boolean value determining if there is a specified colour column
for the plot.
\item \code{paired} Paired ("sequential" or "baseline") as initially passed to \code{\link[=load]{load()}}.
\item \code{ci} Numeric value which determines the range of the confidence interval for effect size
and bootstrap calculations. Only accepts values between 0 to 100 (inclusive).
\item \code{Ns} List of labels for x-axis of the rawdata swarm plot.
\item \code{control_summary} Numeric value for plotting of control summary lines for float_contrast= TRUE.
\item \code{test_summary} Numeric value for plotting of test summary lines for float_contrast = TRUE.
\item \code{ylim} Vector containing the y limits for the rawdata swarm plot.
}
}
\description{
Processes and converts a tidy dataset into the dabestr format.
The output of this function is then used as an input for various procedural
functions within dabestr to create estimation plots.
}
\examples{
# Loading in of the dataset
data(non_proportional_data)

# Creating a dabest object
dabest_obj <- load(
  data = non_proportional_data, x = Group, y = Measurement,
  idx = c("Control 1", "Test 1")
)

# Printing dabest object
print(dabest_obj)

}
