% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsize.R
\name{mean_diff}
\alias{mean_diff}
\alias{median_diff}
\alias{cohens_d}
\alias{hedges_g}
\alias{cliffs_delta}
\title{Compute Effect Size(s)}
\usage{
mean_diff(x, ci = 95, reps = 5000, seed = 12345)

median_diff(x, ci = 95, reps = 5000, seed = 12345)

cohens_d(x, ci = 95, reps = 5000, seed = 12345)

hedges_g(x, ci = 95, reps = 5000, seed = 12345)

cliffs_delta(x, ci = 95, reps = 5000, seed = 12345)
}
\arguments{
\item{x}{A \code{dabest} object, generated by the \link[=dabest]{dabest()}
function.}

\item{ci}{float, default 95. The level of the confidence intervals produced.
The default \code{ci = 95} produces 95\% CIs.}

\item{reps}{integer, default 5000. The number of bootstrap resamples that
will be generated.}

\item{seed}{integer, default 12345. This specifies the seed used to set the
random number generator. Setting a seed ensures that the bootstrap
confidence intervals for the same data will remain stable over separate
runs/calls of this function. See \link{set.seed} for more details.}
}
\value{
A \code{dabest_effsize} object with 10 elements.

  \describe{

  \item{\code{data}}{ The dataset passed to \link[=dabest]{dabest()}, as a
  \code{\link[tibble]{tibble}}. }

  \item{\code{x} and \code{y}}{ The columns in \code{data} used to plot the x
  and y axes, respectively, as supplied to \link[=dabest]{dabest()}. These are
  \href{https://adv-r.hadley.nz/quasiquotation.html}{quoted variables} for
  \href{https://tidyeval.tidyverse.org/}{tidy evaluation} during the
  computation of effect sizes. }

  \item{\code{idx}}{ The vector of control-test groupings as initially passed
  to \link[=dabest]{dabest()}. }

  \item{\code{is.paired}}{ Whether or not the experiment consists of paired
  (aka repeated) observations. Originally supplied to \link[=dabest]{dabest()}. }

  \item{\code{id.column}}{ If \code{is.paired} is \code{TRUE}, the column in
  \code{data} that indicates the pairing of observations. As passed to
  \link[=dabest]{dabest()}. }

  \item{\code{effect.size}}{ The effect size being computed. One of the
  following: \code{c("mean_diff", "median_diff", "cohens_d", "hedges_g",
  "cliffs_delta")}. }

  \item{\code{.data.name}}{ The variable name of the dataset passed to
  \link[=dabest]{dabest()}. }

  \item{\code{summary}}{ A \link{tibble} with a row for the mean or median of
  each group in the \code{x} column of \code{data}, as indicated in
  \code{idx}. }

  \item{\code{result}}{

  A \link{tibble} with the following 15 columns:

  \describe{ \item{control_group, test_group}{ The name of the control group
  and test group respectively.}

  \item{control_size, test_size}{ The number of observations in the control
  group and test group respectively. }

  \item{effect_size}{ The effect size used. }

  \item{paired}{ Is the difference paired (\code{TRUE}) or not
  (\code{FALSE})? }

  \item{difference}{ The effect size of the difference between the two
  groups. }

  \item{variable}{ The variable whose difference is being computed, ie. the
  column supplied to \code{y}. }

  \item{ci}{ The \code{ci} passed to this function. }

  \item{bca_ci_low, bca_ci_high}{ The lower and upper limits of the Bias
  Corrected and Accelerated bootstrap confidence interval. }

  \item{pct_ci_low, pct_ci_high}{ The lower and upper limits of the
  percentile bootstrap confidence interval. }

  \item{bootstraps}{ The vector of bootstrap resamples generated. } } }

  }
}
\description{
For each pair of observations in a \code{dabest} object, a desired effect
size can be computed. Currently there are five effect sizes available:
\itemize{ \item The \strong{mean difference}, given by \code{mean_diff()}.
\item The \strong{median difference}, given by \code{median_diff()}. \item
\strong{Cohen's \emph{d}}, given by \code{cohens_d()}. \item \strong{Hedges'
\emph{g}}, given by \code{hedges_g()}. \item \strong{Cliff's delta}, given by
\code{cliffs_delta()}. }
}
\examples{
# Loading data for unpaired (two independent groups) analysis.
petal_widths <- dabest(iris, Species, Petal.Width,
                       idx = c("setosa", "versicolor"),
                       paired = FALSE)


# Compute the mean difference.
mean_diff(petal_widths)

# Plotting the mean differences.
mean_diff(petal_widths) \%>\% plot()

}
\seealso{
\itemize{

  \item \link[=dabest]{Loading data} for effect size computation.

  \item \link[=plot.dabest_effsize]{Generating estimation plots} after effect
  size computation.

  \item The
  \href{http://www.estimationstats.com/#/about-effect-sizes}{mathematical
  definitions} and equations used to compute each effect size.

  \item The \code{ \link[effsize:effsize-package]{effsize} } package, which
  is used under the hood to compute Cohen's \emph{d}, Hedges' \emph{g}, and
  Cliff's delta.

  \item The \code{ \link[boot]{boot}() } and \code{ \link[boot]{boot.ci}() }
  functions from the \code{boot} package, which generate the (nonparametric)
  bootstrapped resamples used to compute the confidence intervals.

  }
}
