% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.cafs}
\alias{plot.cafs}
\title{Plot Conditional Accuracy Functions (CAFs)}
\usage{
\method{plot}{cafs}(
  x,
  ...,
  conds = NULL,
  col = NULL,
  xlim = NULL,
  ylim = c(0, 1),
  xlab = "Bins",
  ylab = NULL,
  pch = 21,
  lty = 1,
  type = "l",
  legend = NULL,
  legend_pos = "bottomright"
)
}
\arguments{
\item{x}{a \link{data.frame}, containing CAFs, typically resulting from a call
to \link{calc_stats}.}

\item{...}{additional arguments passed to the \link{plot}, \link[graphics:points]{graphics::points},
and \link[graphics:legend]{graphics::legend} functions. Oftentimes, this will (unfortunately) lead
to an error due to a clash of arguments.}

\item{conds}{character vector, specifying the conditions to plot.
Defaults to all unique conditions.}

\item{col}{Character vector, specifying colors for each condition. If a
single color is provided, it will be repeated for each condition.}

\item{xlim, ylim}{numeric vectors of length 2, specifying the x and y axis
limits.}

\item{xlab, ylab}{character, labels for the x and y axes.}

\item{pch}{integer, specifying the plotting symbol for observed data points.}

\item{lty}{integer, line type for the predicted CAFs.}

\item{type}{character, type of plot for the predicted CAFs.}

\item{legend}{character vector, specifying legend labels corresponding to
the conditions in the CAFs. Defaults to the condition names.}

\item{legend_pos}{character, specifying the position of the legend on the
plot.}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
This function generates a plot of Conditional Accuracy Functions (CAFs). It
can display observed and predicted values, making it useful for assessing
model fit or exploring observed data.
}
\details{
The \code{plot.cafs} function allows for a quick investigation of CAFs, including
options for color, symbols, and line types for different data sources
(observed vs. predicted). When the supplied \link{data.frame} includes multiple
IDs, CAFs are aggregated across IDs before plotting.
}
\examples{
# Example 1: Only model predictions ---------------------------------------
# get a cafs data.frame for demonstration purpose
a_model <- dmc_dm(t_max = 1.5, dt = .0025, dx = .0025)
cafs <- calc_stats(a_model, type = "cafs")

# call the plot function with default values
plot(cafs)

# make the plot a little bit more pretty
plot(cafs,
  col = c("green", "red"),
  ylim = c(0.5, 1)
)

# Example 2: Model predictions and observed data --------------------------
obs_data(a_model) <- dmc_synth_data
cafs <- calc_stats(a_model, type = "cafs")
plot(cafs)
# Note: The model was not fitted to the data set, thus observed data and
# model predictions don't match


# Example 3: Only observed data -------------------------------------------
cafs <- calc_stats(dmc_synth_data, type = "cafs")
plot(cafs)

}
