% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{calc_ic}
\alias{calc_ic}
\title{Calculate Information Criteria (AIC and BIC)}
\usage{
calc_ic(drift_dm_obj, ...)
}
\arguments{
\item{drift_dm_obj}{an object of type \link{drift_dm}}

\item{...}{further arguments (only relevant: k, for the penality of
\link[stats:AIC]{stats::AIC})}
}
\value{
A custom object of class \code{stats_dm}
(c("fit_stats", "stats_dm", "data.frame")), containing a data frame with
columns:
\itemize{
\item \code{Log_Like}: the input log-likelihood value
\item \code{AIC}: the calculated AIC value
\item \code{BIC}: the calculated BIC value
}
}
\description{
Computes/Summarizes the Log-Likelihood, Akaike Information Criterion (AIC),
and the Bayesian Information Criterion (BIC)
}
\details{
The functions calls \link{logLik.drift_dm}, and subsequently
\link[stats:AIC]{stats::AIC} and \link[stats:AIC]{stats::BIC}
}
\seealso{
\code{\link[=new_stats_dm]{new_stats_dm()}}, \link{logLik.drift_dm}
}
\keyword{internal}
