% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_flat_subsystems}
\alias{cvd_area_flat_subsystems}
\title{Retieve flat sub-systems for an NHS area, grouped by system level}
\usage{
cvd_area_flat_subsystems(area_id)
}
\arguments{
\item{area_id}{Integer (required). The AreaID for which to retrieve flat sub-system data. use \code{\link[=cvd_area_list]{cvd_area_list()}} or \code{\link[=cvd_area_search]{cvd_area_search()}} to find valid IDs.}
}
\value{
A tibble containing details for the specified area and its child areas and child area details (e.g., via \verb{SubSystems_*} columns). Typical columns include:
\describe{
\item{AreaCode}{Character. Code for the parent NHS area (e.g., "E54000038").}
\item{AreaID}{Integer. Unique identifier for the parent NHS area.}
\item{AreaName}{Character. Name of the parent NHS area (e.g., "Somerset").}
\item{AreaOdsCode}{Character. ODS (Organisation Data Service) code for the parent area (e.g., "QSL").}
\item{ParentAreaID}{Integer. Identifier for the higher-level parent area (e.g., regional or national grouping).}

\item{SubSystems_AreaCode}{Character. Code for the subsystem NHS area (e.g., practice or PCN).}
\item{SubSystems_AreaID}{Integer. Unique identifier for the subsystem NHS area.}
\item{SubSystems_AreaName}{Character. Name of the subsystem NHS area (e.g., "Church Street Surgery, Martock").}
\item{SubSystems_AreaOdsCode}{Character. ODS code for the subsystem area, if available. Often blank.}
\item{SubSystems_ParentAreaID}{Integer. ID of the immediate parent area for the subsystem (e.g., PCN or ICB).}
\item{SubSystems_SystemLevelID}{Integer. Identifier for the system level of the subsystem (e.g., 5 = Practice, 4 = PCN).}
\item{SubSystems_SystemLevelName}{Character. Name of the system level for the subsystem (e.g., "Practice", "PCN").}

\item{SystemLevelID}{Integer. Identifier for the system level of the parent area (e.g., 2 = STP).}
\item{SystemLevelName}{Character. Name of the system level for the parent area (e.g., "STP").}
}
If no data is found, returns a tibble describing the error.
}
\description{
Returns a "flat" list of the specified NHS area and all its immediate child areas from the CVDPREVENT API, with child areas grouped by their system level rather than by strict heirarchical nesting. This function provides a convenient overview when you want to see all sub-areas organised by level (e.g., all PCNs and all GP practices beneath an ICB) without traversing the full heirarchy.

The output is a tibble where each row represents an area or sub-area, and child areas are included as columns (with system level information).
}
\details{
This function is useful for quickly listing all areas beneath a parent, grouped by system level, for reporting or selection purposes. For a fully nested view, see \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}.
}
\note{
This function may take longer than 5 seconds to complete due to API response time.
}
\section{API Documentation}{

See the \href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2F\%3Carea_id\%3E\%2FflatSubSystems}{CVDPREVENT API documentation: Area flat subsystems}
}

\examples{
\donttest{
# View flat sub-systems for Somerset STP (area_id = 5)
cvd_area_flat_subsystems(area_id = 5) |> dplyr::glimpse()

# View flat sub-systems for Lincolnshire ICB (area_id = 8042)
cvd_area_flat_subsystems(area_id = 8042) |> dplyr::glimpse()
}

}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}
}
