% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_group}
\alias{cvd_indicator_group}
\title{Indicator group}
\usage{
cvd_indicator_group(indicator_group_id = 15)
}
\arguments{
\item{indicator_group_id}{integer - the group to return data for (compulsory)}
}
\value{
Tibble of indicators grouped by indicator group
}
\description{
Returns a single indicator group for a given group ID. An error will be
returned if there is no indicator group associated with the given ID.
\code{IndicatorGroup} is the primary key in the IndicatorGroup table, which also
contains \code{IndicatorGroupName} and \code{IndicatorGroupTypeID}. The group type ID
tells you what type of indicator group you're dealing with, e.g. a Priority
Group.
\code{IndicatorGroupTypeID} is the primary key of IndicatorGroupType and so
\code{IndicatorGroupTypeName} is the associated name for the given group type ID.
Finally, there is the array of indicators which are contained in this group,
including display orders for the given group.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FindicatorGroup\%2F\%3Cindicator_group_ID\%3E}{Indicator group}
}
\examples{
#  list the indicators under Indicator Group ID 13 (Monitoring) which lists
# 'Key Question' Indicator Group indicators:
cvd_indicator_group(indicator_group_id = 13) |>
  dplyr::select(IndicatorGroupID, IndicatorGroupName, IndicatorGroupTypeName,
  IndicatorID, IndicatorName)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
