% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_msready_by_mass}
\alias{get_msready_by_mass}
\title{Get msready by mass}
\usage{
get_msready_by_mass(
  start = NULL,
  end = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{start}{The starting value for mass range}

\item{end}{The ending value for mass range}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A list of DTXSIDs with msready mass falling within the given range.
}
\description{
Get msready by mass
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemicals with msready mass in given range
mass_range <- get_msready_by_mass(start = 200.9, end = 200.95)
\dontshow{\}) # examplesIf}
}
