% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctMultigroupFit.R
\name{ctMultigroupFit}
\alias{ctMultigroupFit}
\title{Fits a multiple group continuous time model.}
\usage{
ctMultigroupFit(
  dat,
  groupings,
  ctmodelobj,
  dataform = "wide",
  fixedmodel = NA,
  freemodel = NA,
  carefulFit = TRUE,
  omxStartValues = NULL,
  retryattempts = 5,
  showInits = FALSE,
  ...
)
}
\arguments{
\item{dat}{Wide format data, as used in \code{\link{ctFit}}.  See \code{\link{ctLongToWide}} to
easily convert long format data.}

\item{groupings}{For wide format: Vector of character labels designating group membership for each row of dat.
For long format: Named list of groups, with each list element containing a vector of subject id's for the group.
In both cases, group names will be prefixed on relevant parameter estimates in the summary.}

\item{ctmodelobj}{Continuous time model to fit, specified via \code{\link{ctModel}} function.}

\item{dataform}{either "wide" or "long" depending on which input format you wish to use for the data. 
See details of \code{\link{ctFit}} and or vignette.}

\item{fixedmodel}{Modified version of ctmodelobj, wherein any parameters you wish to keep 
fixed over groups should be given the value 'groupfixed'.  
If specified, all other parameters will be free across groups.}

\item{freemodel}{Modified version of ctmodelobj, wherein any parameters you wish to free across groups
should be given the label 'groupfree'.  
If specified, all other parameters will be fixed across groups.  
If left NULL, the default, all parameters are free across groups.}

\item{carefulFit}{if TRUE, first fits the specified model with a penalised likelihood function 
to discourage parameters from boundary conditions, then
fits the specified model normally, using these estimates as starting values. 
Can help / speed optimization, though results in user specified inits being ignored for the final fit.}

\item{omxStartValues}{A named vector containing the raw (potentially log transformed) OpenMx starting values for free parameters, as captured by
OpenMx function \code{omxGetParameters(ctmodelobj$mxobj)}. These values will take precedence 
over any starting values already specified using ctModel.}

\item{retryattempts}{Number of fit retries to make.}

\item{showInits}{Displays start values prior to optimization}

\item{...}{additional arguments to pass to \code{\link{ctFit}}.}
}
\value{
Returns an OpenMx fit object.
}
\description{
Fits a single continuous time structural equation models to multiple groups (where each group contains 1 or more subjects),
by default, all parameters are free across groups.  Can also be used to easily estimate seperate models for each group.
}
\details{
Additional \code{\link{ctFit}} parameters may be specified as required. Confidence intervals for any matrices and or parameters 
may be estimated afer fitting using \code{\link{ctCI}}.
}
\examples{
\donttest{

#Two group model, all parameters except LAMBDA[3,1] constrained across groups.
data(ctExample4)
basemodel<-ctModel(n.latent=1, n.manifest=3, Tpoints=20,
                   LAMBDA=matrix(c(1, 'lambda2', 'lambda3'), nrow=3, ncol=1),
                   MANIFESTMEANS=matrix(c(0, 'manifestmean2', 'manifestmean3'), 
                   nrow=3, ncol=1), TRAITVAR = 'auto')

freemodel<-basemodel
freemodel$LAMBDA[3,1]<-'groupfree'
groups<-paste0('g',rep(1:2, each=10),'_')

multif<-ctMultigroupFit(dat=ctExample4, groupings=groups,
                       ctmodelobj=basemodel, freemodel=freemodel)
summary(multif,group=1)



#fixed model approach
fixedmodel<-basemodel
fixedmodel$LAMBDA[2,1]<-'groupfixed'
groups<-paste0('g',rep(1:2, each=10),'_')

multif<-ctMultigroupFit(dat=ctExample4, groupings=groups,
                       ctmodelobj=basemodel, fixedmodel=fixedmodel)
summary(multif,group=2) 
}


}
\seealso{
\code{\link{ctFit}} and \code{\link{ctModel}}
}
