% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCompare.R
\name{ctChisqTest}
\alias{ctChisqTest}
\title{Chi Square test wrapper for ctStanFit objects.}
\usage{
ctChisqTest(fit1, fit2)
}
\arguments{
\item{fit1}{One of the fits to be compared (better fit is assumed as base for comparison)}

\item{fit2}{Second fit to be compared}
}
\value{
Numeric probability
}
\description{
Chi Square test wrapper for ctStanFit objects.
}
\examples{
\donttest{
    df <- data.frame(id=1, time=1:length(sunspot.year), Y1=sunspot.year)
    
    m1 <- ctModel(type='dt', LAMBDA=diag(1),MANIFESTVAR=0)
    m2 <- ctModel(type='dt', LAMBDA=diag(1),MANIFESTVAR=0,DRIFT = .9)
    
    f1 <- ctStanFit(df,m1,cores=1)
    f2 <- ctStanFit(df,m2,cores=1)
    
    ctChisqTest(f1,f2)
}
}
