% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_postcalc.R
\name{stan_postcalc}
\alias{stan_postcalc}
\title{Compute functions of matrices from samples of a stanfit object}
\usage{
stan_postcalc(stanfit, object, calc = "object", objectindices = "all",
  summary = TRUE)
}
\arguments{
\item{stanfit}{object of class stanfit.}

\item{object}{name of stan sub object from stanfit to use for calculations.}

\item{calc}{string containing R calculation to evaluate, with the string 'object' in place of the actual object name.}

\item{objectindices}{matrix of indices, with the number of columns matching 
the number of dimensions of the object. 'all' computes \code{which( array(1,objdims)==1,arr.ind=TRUE)},
where objdims is what would be returned by dim(object) if the object existed in the R environment.}

\item{summary}{if FALSE, a iterations * parameters matrix is returned, if TRUE, 
rstan::monitor is first run on the output.}
}
\value{
matrix of values of the specified interactions at each iteration.
}
\description{
Compute functions of matrices from samples of a stanfit object
}
\examples{
temp<-stan_postcalc(stanfit=ctstantestfit$stanfit, 
  object='DRIFT', objectindices='all', calc='exp(object)')
}
