% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ctsemFit.R
\name{ctPlot}
\alias{ctPlot}
\title{ctPlot}
\usage{
ctPlot(x, plotType, xlim, resolution = 50, impulseIndex = NULL,
  subject = 1, typeVector = "auto", colVector = "auto",
  ltyVector = "auto", ...)
}
\arguments{
\item{x}{ctsemFit object as generated by \code{\link{ctFit}}.}

\item{plotType}{string. "mean" for expectation independent of any data, 
"AR" for autoregressions, "CR" for cross regressions, 
"standardiseCR" for standardised cross regressions (standardised based on estimated within subject variance), 
"withinVar" for within variance and covariance,
"randomImpulse" for expected change in processes given a random fluctuation of +1 for each process 
(so a mixture of DIFFUSION and DRIFT characteristics),
"experimentalImpulse" for expected change in processes given an exogenous input of +1 for each process, provides 
alternate characterisation of autoregressive and cross regressive plots.}

\item{xlim}{vector. As per usual for plot(), but xlim may not be negative.}

\item{resolution}{Numeric. Plot points between each unit of time. Default of 'auto' adapts to xlim and results in 500 points in total.}

\item{impulseIndex}{Numeric. Only required for impulse plot types, specifies which column of the DRIFT matrix the impulse relates to.}

\item{subject}{numeric. Specifies the subject (row of data from the mxobj) to plot for factorScores type plot.}

\item{typeVector}{Vector of plot types to use for plotting.}

\item{colVector}{vector of colours to use for plotting.}

\item{ltyVector}{Vector of line types to use for plotting.}

\item{...}{Other options passed to \code{plot()}. ylim is required.}
}
\value{
Character vector of labels from the DRIFT matrix in order plotted - useful for legends. Side-effect: plots graphs.
}
\description{
Plots mean trajectories, autoregression, and crossregression plots, for ctsemFit objects. 
More customizeable than basic plot.ctsemFit function.
}
\examples{
## Examples set to 'dontrun' because they take longer than 5s.

### example from Driver, Oud, Voelkle (2016), 
### simulated happiness and leisure time with unobserved heterogeneity.
\dontrun{
data(ctExample1)
traitmodel <- ctModel(n.manifest=2, n.latent=2, Tpoints=6, LAMBDA=diag(2), 
  manifestNames=c('LeisureTime', 'Happiness'), 
  latentNames=c('LeisureTime', 'Happiness'), TRAITVAR="auto")
traitfit <- ctFit(datawide=ctExample1, ctmodelobj=traitmodel)
ctPlot(traitfit, type='CR', xlim=c(0,5),ylim=c(-1,1))
}
}

