% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ctFit.R
\name{ctFit}
\alias{ctFit}
\title{Fit a ctsem object}
\usage{
ctFit(datawide, ctmodelobj, confidenceintervals = NULL, objective = "auto",
  stationary = c("T0TIPREDEFFECT"), optimizer = "SLSQP",
  retryattempts = 10, iterationSummary = TRUE, carefulFit = FALSE,
  showInits = FALSE, asymptotes = FALSE, meanIntervals = FALSE,
  plotOptimization = F, nofit = FALSE, discreteTime = FALSE,
  verbose = 0, useOptimizer = TRUE, omxStartValues = NULL)
}
\arguments{
\item{datawide}{the data you wish to fit a ctsem model to.}

\item{ctmodelobj}{the ctsem model object you wish to use, specified via the \code{\link{ctModel}} function.}

\item{confidenceintervals}{vector of character strings of matrices or single parameters
to calculate 95\% confidence intervals for.  e.g. c("DRIFT", "TRAITVAR").}

\item{objective}{'auto' selects either 'Kalman', if fitting to single subject data,
or 'mxRAM' for multiple subjects. For single subject data, 'Kalman' uses the \code{mxExpectationStateSpace }
function from OpenMx to implement the Kalman filter.
For more than one subject, 'mxRAM' specifies a wide format SEM with a row of data per subject.
'cov' may be specified, in which case the 'meanIntervals' argument is set to TRUE, and the covariance matrix
of the supplied data is calculated and fit instead of the raw data. This is much faster but only a rough approximation,
unless there are no individual differences in time interval and no missing data.
'Kalman' may be specified for multiple subjects, however as no trait matrices are used by the Kalman filter
one must consider how average level differences between subjects are accounted for.
See \code{\link{ctMultigroupFit}} for the possibility to apply the Kalman filter over multiple subjects)}

\item{stationary}{Character vector of T0 matrix names in which to constrain any free parameters to stationarity.
Defaults to c('T0TIPREDEFFECT'), constraining only the between subject difference effects.
Can be set to NULL to force all T0 matrices to be estimated, can be
set to 'all' to constrain all T0 matrices to stationarity.}

\item{optimizer}{character string, defaults to the open-source 'SLSQP' optimizer that is distributed
in all versions of OpenMx. However, 'NPSOL' may sometimes perform better for these problems,
though requires that you have installed OpenMx manually, by running:
\code{source('http://openmx.psyc.virginia.edu/getOpenMx.R')}}

\item{retryattempts}{Number of times to retry the start value randomisation and fit procedure, if non-convergance or uncertain fits occur.}

\item{iterationSummary}{if TRUE, outputs limited fit details after every fit attempt.}

\item{carefulFit}{if TRUE, first fits the specified model with a penalised likelihood function
to force MANIFESTVAR, DRIFT, TRAITVAR, MANIFESTTRAITVAR parameters to remain close to 0, then
fits the specified model normally, using these estimates as starting values.
Can help with optimization when extreme parameter estimates are returned,
though results in user specified start values being ignored for the final fit.}

\item{showInits}{if TRUE, prints the list of user specified and auto generated
starting values for free parameters.}

\item{asymptotes}{when TRUE, optimizes over asymptotic parameter matrices instead of continuous time parameter matrices.
Can be useful for optimization and model development, but should result in equivalent models if optimization is adequate.}

\item{meanIntervals}{Use average time intervals for each column for calculation
(both faster and inaccurate to the extent that intervals vary across individuals).}

\item{plotOptimization}{If TRUE, uses checkpointing for OpenMx function \code{mxRun}, set to checkpoint every iteration,
output checkpoint file to working directory, then creates a plot for each parameter's values over iterations.}

\item{nofit}{if TRUE, output only openmx model without fitting}

\item{discreteTime}{Estimate a discrete time model - ignores timing information, parameter
estimates will correspond to those of classical vector autoregression models,
OpenMx fit object will be directly output, thus ctsem summary and plot functionality will be unavailable.
Time dependent predictor type also becomes irrelevant.}

\item{verbose}{Integer between 0 and 3. Sets mxComputeGradientDescent messaging level, defaults to 0.}

\item{useOptimizer}{Logical. Defaults to TRUE.  Passes argument to \code{mxRun},
useful for using custom optimizers or fitting to specified parameters.}

\item{omxStartValues}{A named vector containing already transformed (e.g. \code{log(-(driftdiagonalparam))} or
\code{log(diffusionvarianceeparam)} starting values for free parameters, as captured by
OpenMx function \code{omxGetParameters(ctmodelobj$mxobj)}. These values will take precedence
over any starting values already specified using ctModel.}
}
\description{
This function fits continuous time SEM models specified via \code{\link{ctModel}}
to a dataset containing one or more subjects.
}
\details{
DATA STRUCTURE:
 Single row per subject. Manifest variables first, grouped by measurement occasion (with later measurements to the right),
 then 1st time dependent predictor (all observations 1:(Tpoints-1)), further time dependent predictors,
 time intervals between observations, time independent predictors.
}
\examples{
mfrowOld<-par()$mfrow
par(mfrow=c(2, 3))

### example from Driver, Oud, Voelkle (2015),
### simulated happiness and leisure time with unobserved heterogeneity.
data(ctExample1)
traitmodel <- ctModel(n.manifest=2, n.latent=2, Tpoints=6, LAMBDA=diag(2),
  manifestNames=c('LeisureTime', 'Happiness'),
  latentNames=c('LeisureTime', 'Happiness'), TRAITVAR="auto")
traitfit <- ctFit(datawide=ctExample1, ctmodelobj=traitmodel)
summary(traitfit)
\dontrun{
plot(traitfit, wait=FALSE)


###Example from Voelkle, Oud, Davidov, and Schmidt (2012) - anomia and authoritarianism.
data(AnomAuth)
AnomAuthmodel <- ctModel(LAMBDA = matrix(c(1, 0, 0, 1), nrow = 2, ncol = 2),
Tpoints = 5, n.latent = 2, n.manifest = 2, MANIFESTVAR=diag(0, 2), TRAITVAR = NULL)
AnomAuthfit <- ctFit(AnomAuth, AnomAuthmodel)
summary(AnomAuthfit)


### Single subject time series - using Kalman filter (OpenMx statespace expectation)
data('ctExample3')
model <- ctModel(n.latent = 1, n.manifest = 3, Tpoints = 100,
  LAMBDA = matrix(c(1, 'lambda2', 'lambda3'), nrow = 3, ncol = 1),
  MANIFESTMEANS = matrix(c(0, 'manifestmean2', 'manifestmean3'), nrow = 3,
    ncol = 1))
fit <- ctFit(data = ctExample3, ctmodelobj = model, objective = 'Kalman',
  stationary = c('T0VAR'))


###Oscillating model from Voelkle & Oud (2013).
data(Oscillating)
inits <- c(-38,-.5,1,10,10)
names(inits)<-c('cross','auto','diffusion22','T0var11','T0var22')
oscillatingm<-ctModel(n.latent = 2, n.manifest=1, Tpoints=11,
 MANIFESTVAR=matrix(c(0), nrow=1, ncol=1),
 LAMBDA=matrix(c(1, 0), nrow=1, ncol=2),
 DRIFT=matrix(c(0, "cross", 1, "auto"), nrow=2, ncol=2),
 CINT=matrix(c(0,0), ncol=1, nrow=2, ),
 DIFFUSION=matrix(c(0, 0, 0, "diffusion22"), nrow=2, ncol=2),
 startValues = inits)
oscillatingf<-ctFit(Oscillating, oscillatingm, optimizer='SLSQP')
summary(oscillatingf)
}
}

