% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_xts.R
\name{write_xts}
\alias{write_xts}
\alias{read_xts}
\title{Read and Write \code{xts}-objects}
\usage{
# write XTS-object
write_xts(
 x,
 file,
 ...
)

# read XTS-object
read_xts(
file
)
}
\arguments{
\item{x}{An <[\link[xts]{xts}]>-object.}

\item{file}{character string or strings giving the name of the file(s) 
    which the data
    are to be read from/written to. See \code{\link{read.table}} and
    \code{\link{write.table}} for more information. Alternatively,
    in \code{read.zoo}, \code{file} can be a \code{connection} or a
	\code{data.frame} (e.g.,
    resulting from a previous \code{read.table} call) that
    is subsequently processed to a \code{"zoo"} series.}

\item{...}{further arguments passed to other functions. In the \code{read.*.zoo}
    the arguments are passed to the function specified in \code{read}
    (unless \code{file} is a \code{data.frame} already). In \code{write.zoo} the
    arguments are passed to \code{\link{write.table}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{\link[=write_xts]{write_xts()}}- and \code{\link[=read_xts]{read_xts()}}-functions are  \code{\link[zoo:write.zoo]{zoo::write.zoo()}}- and \code{\link[zoo:read.zoo]{zoo::read.zoo()}}-wrapper functions.
}
\details{
When reading and writing <[\link[xts]{xts}]>-objects the \link{attributes} does not follow the object.
}
\seealso{
Other utility: 
\code{\link{calibrate_window}()},
\code{\link{remove_bound}()},
\code{\link{split_window}()}

Other utility: 
\code{\link{calibrate_window}()},
\code{\link{remove_bound}()},
\code{\link{split_window}()}
}
\author{
Serkan Korkmaz
}
\concept{utility}
