% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXDS_ASCII.R
\name{writeXDS_ASCII}
\alias{writeXDS_ASCII}
\title{Write data to an XDS_ASCII file.}
\usage{
writeXDS_ASCII(proc_info, header, reflections, filename)
}
\arguments{
\item{proc_info}{The first component of an XDS_ASCII-type
object. It includes up to three
components, \code{MERGE}, \code{FRIEDEL}
and \code{PROFILE_FITTING} (this last
component is missing for files with
merged observations, obtained with the
program XSCALE).}

\item{header}{The second component of an XDS_ASCII-type object.
This object includes several other objects (see
\code{\link{readXDS_ASCII}}).}

\item{reflections}{The third component of an XDS_ASCII-type
object. It contains the data (the
experimental observations). See
\code{\link{readXDS_ASCII}} for more details.}

\item{filename}{A character string. The path to a valid
XDS_ASCII file. If a file with the same name
exists, it will be deleted.}
}
\value{
This function does not return any R object. It outputs
        an XDS_ASCII reflection file to some target location.
}
\description{
Function to write an XDS_ASCII-tye named list to a file with
XDS_ASCII format (unmerged or merged).
}
\details{
The XDS_ASCII-type named list includes three components,
\code{processing_info}, \code{header} and \code{reflections}
(see \code{\link{readXDS_ASCII}}).
}
\examples{

# Load one of the XDS ASCII files included with
# this distribution of cry
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"xds00_ascii.hkl")
lXDS <- readXDS_ASCII(filename)

# Change date
print(lXDS$header$DATE)
lXDS$header$DATE <- "7-Apr-2021"

# Write to a file called "new.hkl"
wd <- tempdir()
fname <- file.path(wd,"new.hkl")
writeXDS_ASCII(lXDS$processing_info,lXDS$header,
               lXDS$reflections,fname)

}
