% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsra_membershares.R
\name{crsra_membershares}
\alias{crsra_membershares}
\title{The share of learners in each course based on specific characteristics.}
\usage{
crsra_membershares(all_tables, groupby = c("roles", "country", "language",
  "gender", "empstatus", "education", "stustatus"), remove_missing = TRUE)
}
\arguments{
\item{all_tables}{A list from \code{\link{crsra_import_course}} or
\code{\link{crsra_import}}}

\item{groupby}{A character string indicating the how to break down learners
in each course. The default is set to \code{roles} and returns the
share of students in each category such as Learner, Not Enrolled,
Pre-Enrolled Learner, Mentor, Browser, and Instructor.
Other values are \code{country} (for grouping based on country),
\code{language} (for grouping based on language), \code{gender}
(for grouping by gender), \code{education} (for grouping by
education level), \code{stustatus} (for grouping by student status),
 \code{empstatus} (for grouping by employment status), and \code{country}
 (for grouping by country). Note that this grouping uses the entries
 in the table \code{users} that is not fully populated so by grouping
  you lose some observations.}

\item{remove_missing}{Should the \code{NA} be removed from the
\code{groupby} column?}
}
\value{
A table which indicates the total number and the share of
students in each group for each course
}
\description{
The share of learners in each course based on specific characteristics.
}
\examples{
crsra_membershares(
example_course_import,
groupby = "country")
crsra_membershares(
example_course_import,
groupby = "roles", remove_missing = FALSE)
crsra_membershares(
example_course_import,
groupby = "roles", remove_missing = TRUE)
}
