% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpoint-class}
\alias{DualEndpoint-class}
\alias{.DualEndpoint}
\alias{DualEndpoint}
\alias{.DefaultDualEndpoint}
\title{\code{DualEndpoint}}
\usage{
DualEndpoint(mean, cov, ref_dose = 1, use_log_dose = FALSE, sigma2W, rho)

.DefaultDualEndpoint()
}
\arguments{
\item{mean}{(\code{numeric})\cr for the probit toxicity model, the prior mean vector.}

\item{cov}{(\code{matrix})\cr for the probit toxicity model, the prior covariance
matrix. The precision matrix is internally calculated as an inverse of \code{cov}.}

\item{ref_dose}{(\code{number})\cr for the probit toxicity model, the reference
dose \eqn{x*} (strictly positive number).}

\item{use_log_dose}{(\code{flag})\cr for the probit toxicity model, whether a log
transformation of the (standardized) dose should be used?}

\item{sigma2W}{(\code{numeric})\cr the biomarker variance. Either a fixed value or
Inverse-Gamma distribution parameters, i.e. vector with two elements named
\code{a} and \code{b}.}

\item{rho}{(\code{numeric})\cr either a fixed value for the correlation
(between \code{-1} and \code{1}), or a named vector with two elements named \code{a} and \code{b}
for the Beta prior on the transformation \code{kappa = (rho + 1) / 2}, which is
in \verb{(0, 1)}. For example, \verb{a = 1, b = 1} leads to a uniform prior on \code{rho}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{DualEndpoint}} is the general class for the dual endpoint model.
}
\details{
The idea of the dual-endpoint models is to model not only the
dose-toxicity relationship, but also to model, at the same time, the
relationship of a PD biomarker with the dose. The sub-classes of this class
define how the dose-biomarker relationship is parametrized. This class here
shall contain all the common features to reduce duplicate code.
(This class however, must not be virtual as we need to create objects
of it during the construction of subclass objects.)

The dose-toxicity relationship is modeled with probit regression model
\deqn{probit[p(x)] = betaZ1 + betaZ2 * x/x*,}
or
\deqn{probit[p(x)] = betaZ1 + betaZ2 * log(x/x*),}
in case when the option \code{use_log_dose} is \code{TRUE}.
Here, \eqn{p(x)} is the probability of observing a DLT for a given
dose \eqn{x} and \eqn{x*} is the reference dose.
The prior \deqn{(betaZ1, log(betaZ2)) ~ Normal(mean, cov).}

For the biomarker response \eqn{w} at a dose \eqn{x}, we assume
\deqn{w(x) ~ Normal(f(x), sigma2W),}
where \eqn{f(x)} is a function of the dose \eqn{x}, which is further
specified in sub-classes. The biomarker variance \eqn{sigma2W} can be fixed
or assigned an Inverse-Gamma prior distribution; see the details below under
slot \code{sigma2W}.

Finally, the two endpoints \eqn{y} (the binary DLT variable) and \eqn{w}
(the biomarker) can be correlated, by assuming a correlation of level
\eqn{rho} between the underlying continuous latent toxicity variable \eqn{z}
and the biomarker \eqn{w}. Again, this correlation can be fixed or assigned
a prior distribution from the scaled Beta family; see the details below
under slot \code{rho}.

Please see the example vignette by typing \code{crmPackExample()} for a full example.
}
\section{Slots}{

\describe{
\item{\code{betaZ_params}}{(\code{ModelParamsNormal})\cr for the probit toxicity model, it
contains the prior mean, covariance matrix and precision matrix which is
internally calculated as an inverse of the covariance matrix.}

\item{\code{ref_dose}}{(\code{positive_number})\cr for the probit toxicity model, the
reference dose.}

\item{\code{use_log_dose}}{(\code{flag})\cr for the probit toxicity model, whether a log
transformation of the (standardized) dose should be used?}

\item{\code{sigma2W}}{(\code{numeric})\cr the biomarker variance. Either a fixed value or
Inverse-Gamma distribution parameters, i.e. vector with two elements named
\code{a} and \code{b}.}

\item{\code{rho}}{(\code{numeric})\cr either a fixed value for the correlation
(between \code{-1} and \code{1}), or a named vector with two elements named \code{a} and \code{b}
for the Beta prior on the transformation \code{kappa = (rho + 1) / 2}, which is
in \verb{(0, 1)}. For example, \verb{a = 1, b = 1} leads to a uniform prior on \code{rho}.}

\item{\code{use_fixed}}{(\code{logical})\cr indicates whether a fixed value for \code{sigma2W}
or \code{rho} (for each parameter separately) is used or not. This slot is
needed for internal purposes and must not be touched by the user.}
}}

\note{
Typically, end users will not use the \code{.DefaultDualEndpoint()} function.
}
\seealso{
\code{\link{DualEndpointRW}}, \code{\link{DualEndpointBeta}}, \code{\link{DualEndpointEmax}}.
}
