% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_fit_pdfsp.R
\name{calib_clim_space}
\alias{calib_clim_space}
\title{Calibrate the distribution of the modern climate space.}
\usage{
calib_clim_space(climate, bin_width)
}
\arguments{
\item{climate}{A vector of climatic values where the species is present.}

\item{bin_width}{The width of the bins used to correct for unbalanced climate
state. Use values that split the studied climate gradient in
15-25 classes (e.g. 2°C for temperature variables). Default is 1.}
}
\value{
A \code{ccs} object that will be used by \code{\link{fit_pdfsp}}.
}
\description{
Calibrate the distribution of the modern climate space.
}
\examples{
calib_clim_space(sample(0:300 / 10, 4000, replace = TRUE), 2)

}
