% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.combinedPDFS.R
\name{plot_combinedPDFs}
\alias{plot_combinedPDFs}
\title{Plot representing how the \code{pdfs} combine to produce the reconstruction.}
\usage{
plot_combinedPDFs(
  x,
  samples = 1:length(x$inputs$x),
  climate = x$parameters$climate[1],
  optima = TRUE,
  xlim = NA,
  only.present = FALSE,
  only.selected = FALSE,
  col = crestr::colour_theme(1),
  save = FALSE,
  filename = "samplePDFs.pdf",
  as.png = FALSE,
  png.res = 300,
  width = 7.48,
  height = 5
)
}
\arguments{
\item{x}{A \code{\link{crestObj}} generated by the
\code{\link{crest.reconstruct}} or \code{\link{crest}} functions.}

\item{samples}{The list of samples for which the plot should be plotted. All
samples will be plotted by default.}

\item{climate}{The climate variable to use to plot the variable. Default is
first variable (\code{x$parameters$climate\[1\]}).}

\item{optima}{A boolean to indicate whether to plot the optimum (\code{TRUE})
or the mean (\code{FALSE}) estimates.}

\item{xlim}{The climate range to plot the pdfs on. Default is the full range
used to fit the \code{pdfs} (x$modelling$xrange).}

\item{only.present}{A boolean to only add the names of the taxa recorded in
the sample (default \code{FALSE}).}

\item{only.selected}{A boolean to only add the names of the selected taxa
(default \code{FALSE}).}

\item{col}{A range of colour values to colour the \code{pdfs}. Colours will
be recycled to match the number of taxa.}

\item{save}{A boolean to indicate if the diagram should be saved as a pdf file.
Default is \code{FALSE}.}

\item{filename}{An absolute or relative path that indicates where the diagram
should be saved. Also used to specify the name of the file. Default:
the file is saved in the working directory under the name
\code{'samplePDFs.pdf'}.}

\item{as.png}{A boolean to indicate if the output should be saved as a png.
Default is \code{FALSE} and the figure is saved as a pdf file.}

\item{png.res}{The resolution of the png file (default 300 pixels per inch).}

\item{width}{The width of the output file in inches (default 7.48in ~ 19cm).}

\item{height}{The height of the output file in inches (default 5in ~ 12.7cm).}
}
\value{
No return value, this function is used to plot.
}
\description{
Plot representing how the \code{pdfs} combine to produce the reconstruction.
}
\examples{
\dontrun{
  data(crest_ex)
  data(crest_ex_pse)
  data(crest_ex_selection)
  reconstr <- crest(
    df = crest_ex, pse = crest_ex_pse, taxaType = 0,
    climate = c("bio1", "bio12"), bin_width = c(2, 20),
    shape = c("normal", "lognormal"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example",
    leave_one_out = FALSE
   )
}
## example using pre-saved reconstruction obtained with the previous command.
data(reconstr)
plot_combinedPDFs(reconstr, samples=1:4, climate='bio12')

}
