% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_survfit_times.R, R/add_difference_row.R
\name{tbl_survfit_times}
\alias{tbl_survfit_times}
\alias{add_difference_row.tbl_survfit_times}
\alias{add_overall.tbl_survfit_times}
\title{Survival Times}
\usage{
tbl_survfit_times(
  data,
  times,
  y = "survival::Surv(time = AVAL, event = 1 - CNSR, type = 'right', origin = 0)",
  by = NULL,
  label = "Time {time}",
  statistic = c("{n.risk}", "{estimate}", "({conf.low}, {conf.high})"),
  estimate_fun = label_roche_number(digits = 1, scale = 100),
  method.args = list(conf.int = 0.95)
)

\method{add_difference_row}{tbl_survfit_times}(
  x,
  reference,
  statistic = c("{estimate}", "({conf.low}, {conf.high})", "{p.value}"),
  conf.level = 0.95,
  pvalue_fun = label_roche_pvalue(),
  estimate_fun = label_roche_number(digits = 2, scale = 100),
  ...
)

\method{add_overall}{tbl_survfit_times}(
  x,
  last = FALSE,
  col_label = "All Participants  \\nN = {style_roche_number(N)}",
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
A data frame}

\item{times}{(\code{numeric})\cr
a vector of times for which to return survival probabilities.}

\item{y}{(\code{string} or \code{expression})\cr
A string or expression with the survival outcome, e.g. \code{survival::Surv(time, status)}.
The default value is
\code{survival::Surv(time = AVAL, event = 1 - CNSR, type = "right", origin = 0)}.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}, which returns results for the unstratified model.}

\item{label}{(\code{string})\cr
Label to appear in the header row. Default is \code{"Time {time}"}, where
the glue syntax injects the time estimate into the label.}

\item{statistic}{(\code{character})\cr
Character vector of the statistics to report.
May use any of the following statistics:
\code{c(n.risk, estimate, std.error, conf.low, conf.high)},
Default is \code{c("{n.risk}", "{estimate}", "({conf.low}, {conf.high})")}

Statistics available to include when using \code{add_difference_row()} are:
\code{"estimate"}, \code{"std.error"}, \code{"statistic"}, \code{"conf.low"}, \code{"conf.high"}, \code{"p.value"}.}

\item{estimate_fun}{(\code{function}) \cr
Function used to style/round the \code{c(estimate, conf.low, conf.high)} statistics.}

\item{method.args}{(named \code{list})\cr
Named list of arguments that will be passed to \code{survival::survfit()}.

Note that this list may contain non-standard evaluation components, and
must be handled similarly to tidyselect inputs by using
rlang's embrace operator \code{{{ . }}} or \code{!!enquo()} when programming with this
function.}

\item{x}{(\code{tbl_survfit_times})\cr
A stratified 'tbl_survfit_times' object}

\item{reference}{(\code{string})\cr
Value of the \code{tbl_survfit_times(by)} variable value that is the reference for
each of the difference calculations. For factors, use the character
level. The reference column will appear as the leftmost column in the table.}

\item{conf.level}{(\code{numeric})\cr
a scalar in the interval \verb{(0, 1)} indicating the confidence level. Default is 0.95}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format the \code{p.value} statistic. Default is \code{\link[=label_roche_pvalue]{label_roche_pvalue()}}.
The function must have a numeric vector input, and return a string that is the
rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 3)}).}

\item{...}{These dots are for future extensions and must be empty.}

\item{last}{(scalar \code{logical})\cr
Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}

\item{col_label}{(\code{string})\cr
String indicating the column label. Default is \code{"**Overall**  \nN = {style_number(N)}"}}
}
\value{
a gtsummary table
}
\description{
Create a gtsummary table with Kaplan-Meier estimated survival estimates
and specified times.
}
\details{
When the \code{statistic} argument is modified, the statistic labels will likely
also need to be updated. To change the label, call the \code{modify_table_body()}
function to directly update the underlying \code{x$table_body} data frame.
}
\section{Methods (by generic)}{
\itemize{
\item \code{add_difference_row(tbl_survfit_times)}: Adds survival differences between groups as additional rows to tables created by \code{\link[=tbl_survfit_times]{tbl_survfit_times()}}.

Difference statistics are calculated using \code{\link[cardx:ard_survival_survfit_diff]{cardx::ard_survival_survfit_diff()}}
for all \code{tbl_survfit_times(times)} variable values, using \code{survfit} formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{survival::survfit(y ~ by, data = data)
}\if{html}{\out{</div>}}

where \code{y}, \code{by} and \code{data} are the inputs of the same names to the \code{tbl_survfit_times()} object \code{x}.

Pairwise differences are calculated relative to the specified \code{by} variable's specified reference level.

}}
\examples{
# Example 1 ----------------------------------
tbl_survfit_times(
  data = cards::ADTTE,
  by = "TRTA",
  times = c(30, 60),
  label = "Day {time}"
) |>
  add_overall()
# Example 2 - Survival Differences -----------
tbl_survfit_times(
  data = cards::ADTTE,
  by = "TRTA",
  times = c(30, 60),
  label = "Day {time}"
) |>
  add_difference_row(reference = "Placebo")
}
