% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline.plot.R
\name{baseline.plot}
\alias{baseline.plot}
\title{Plot the simulated baseline functions}
\usage{
baseline.plot(baseline)
}
\arguments{
\item{baseline}{A data frame containing five variables: time, and the values of the baseline failure PDF,
baseline failure CDF, baseline survivor function, and baseline hazard function at each time point.
Generally, this data frame is taken from the \code{baseline} attribute of the \code{\link[coxed]{sim.survdata}}
function}
}
\value{
A figure of class \code{"gg"} and \code{"ggplot"}
}
\description{
This function is called by \code{\link[coxed]{survsim.plot}} and is not intended to be used by itself.
}
\details{
This function reshapes the data for easy faceting with \code{\link[ggplot2]{facet_wrap}} within
a call to \code{\link[ggplot2]{ggplot}}. Each function is plotted on the y-axis and time is plotted on
the x-axis using \code{\link[ggplot2:geom_path]{geom_line}}
}
\examples{
simdata <- sim.survdata(N=1000, T=100, num.data.frames=1)
baseline.plot(simdata$baseline)
}
\seealso{
\code{\link[coxed]{survsim.plot}}, \code{\link[coxed]{sim.survdata}}
}
\author{
Jonathan Kropko <jkropko@virginia.edu> and Jeffrey J. Harden <jharden2@nd.edu>
}
