% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_emissions_inputs.R
\name{calc_emissions_inputs}
\alias{calc_emissions_inputs}
\title{Calculate indirect emissions from purchased inputs}
\usage{
calc_emissions_inputs(
  conc_kg = 0,
  fert_n_kg = 0,
  plastic_kg = 0,
  feed_grain_dry_kg = 0,
  feed_grain_wet_kg = 0,
  feed_ration_kg = 0,
  feed_byproducts_kg = 0,
  feed_proteins_kg = 0,
  feed_corn_kg = 0,
  feed_soy_kg = 0,
  feed_wheat_kg = 0,
  region = "global",
  fert_type = "mixed",
  plastic_type = "mixed",
  include_uncertainty = FALSE,
  transport_km = NULL,
  ef_conc = NULL,
  ef_fert = NULL,
  ef_plastic = NULL,
  boundaries = NULL
)
}
\arguments{
\item{conc_kg}{Numeric. Purchased concentrate feed (kg/year). Default = 0.}

\item{fert_n_kg}{Numeric. Purchased nitrogen fertilizer (kg N/year). Default = 0.}

\item{plastic_kg}{Numeric. Agricultural plastics used (kg/year). Default = 0.}

\item{feed_grain_dry_kg}{Numeric. Grain dry (kg/year, DM). Default = 0.}

\item{feed_grain_wet_kg}{Numeric. Grain wet (kg/year, DM). Default = 0.}

\item{feed_ration_kg}{Numeric. Ration (total mixed ration) (kg/year, DM). Default = 0.}

\item{feed_byproducts_kg}{Numeric. Byproducts (kg/year, DM). Default = 0.}

\item{feed_proteins_kg}{Numeric. Protein feeds (kg/year, DM). Default = 0.}

\item{feed_corn_kg}{Numeric. Corn (kg/year, DM). Default = 0.}

\item{feed_soy_kg}{Numeric. Soybean meal (kg/year, DM). Default = 0.}

\item{feed_wheat_kg}{Numeric. Wheat (kg/year, DM). Default = 0.}

\item{region}{Character. "EU","US","Brazil","Argentina","Australia","global". Default "global".}

\item{fert_type}{Character. "urea","ammonium_nitrate","mixed","organic". Default "mixed".}

\item{plastic_type}{Character. "LDPE","HDPE","PP","mixed". Default "mixed".}

\item{include_uncertainty}{Logical. Include uncertainty ranges? Default FALSE.}

\item{transport_km}{Numeric. Average feed transport distance (km). Optional.}

\item{ef_conc, ef_fert, ef_plastic}{Numeric overrides for emission factors (kg CO2e per unit).}

\item{boundaries}{Optional. Object from \code{set_system_boundaries()}.}
}
\value{
A list with fields:
\itemize{
\item source = "inputs"
\item emissions_breakdown (named values per input)
\item co2eq_kg (numeric total)
\item total_co2eq_kg (duplicate of co2eq_kg)
\item emission_factors_used, inputs_summary, contribution_analysis, uncertainty (if requested)
\item metadata (methodology, standards, date)
}
}
\description{
Estimates CO2e emissions from purchased inputs such as feeds, fertilizers,
and plastics using regional factors, with optional uncertainty analysis.
}
\details{
Notes:
\itemize{
\item When system boundaries exclude "inputs", this function MUST return a list
with \code{source = "inputs"} and a numeric \code{co2eq_kg = 0} to satisfy
partial-boundaries integration.
\item The primary total field is \code{co2eq_kg} (for compatibility with
\code{calc_total_emissions()}); \code{total_co2eq_kg} is included as a duplicate for
convenience.
}
}
\examples{
# Quick example (runs fast)
calc_emissions_inputs(conc_kg = 1000, fert_n_kg = 200, region = "EU")

\donttest{
# With uncertainty analysis (Monte Carlo)
calc_emissions_inputs(feed_corn_kg = 2000, region = "US", include_uncertainty = TRUE)

# Boundaries exclusion example: "inputs" not included -> co2eq_kg = 0
b <- list(include = c("enteric", "manure", "soil", "energy"))  # inputs excluded
calc_emissions_inputs(conc_kg = 500, fert_n_kg = 100, boundaries = b)$co2eq_kg  # 0
}
}
