% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_costs}
\alias{example_costs}
\title{Example cost matrices for assignment problems}
\format{
A list containing four example cost matrices:
\describe{
\item{simple_3x3}{A 3x3 cost matrix with costs ranging from 2-7. Optimal
assignment: row 1 -> col 2 (cost 2), row 2 -> col 1 (cost 3),
row 3 -> col 3 (cost 4). Total optimal cost: 9.}
\item{rectangular_3x5}{A 3x5 rectangular cost matrix demonstrating
assignment when rows < columns. Each of 3 rows is assigned to one of
5 columns; 2 columns remain unassigned. Costs range 1-6.}
\item{sparse_with_na}{A 3x3 matrix with NA values indicating forbidden
assignments. Use this to test algorithms' handling of constraints.
Position (1,3), (2,2), and (3,1) are forbidden.}
\item{binary_costs}{A 3x3 matrix with binary (0/1) costs, suitable for
testing the HK01 algorithm. Diagonal entries are 0 (preferred),
off-diagonal entries are 1 (penalty).}
}
}
\usage{
example_costs
}
\description{
Small example datasets for demonstrating couplr functionality across
different assignment problem types: square, rectangular, sparse, and binary.
}
\details{
These matrices are designed to test different aspects of LAP solvers:

\strong{simple_3x3}: Basic functionality test. Any correct solver should
find total cost = 9.

\strong{rectangular_3x5}: Tests handling of non-square problems. The
optimal solution assigns all 3 rows with minimum total cost.

\strong{sparse_with_na}: Tests constraint handling. Algorithms must avoid
NA positions while finding an optimal assignment among valid entries.

\strong{binary_costs}: Tests specialized binary cost algorithms. The
optimal assignment uses all diagonal entries (total cost = 0).
}
\examples{
# Simple 3x3 assignment
result <- lap_solve(example_costs$simple_3x3)
print(result)
# Optimal: sources 1,2,3 -> targets 2,1,3 with cost 9

# Rectangular problem (3 sources, 5 targets)
result <- lap_solve(example_costs$rectangular_3x5)
print(result)
# All 3 sources assigned; 2 targets unassigned

# Sparse problem with forbidden assignments
result <- lap_solve(example_costs$sparse_with_na)
print(result)
# Avoids NA positions

# Binary costs - test HK01 algorithm
result <- lap_solve(example_costs$binary_costs, method = "hk01")
print(result)
# Finds diagonal assignment (cost = 0)

}
\seealso{
\code{\link{lap_solve}}, \code{\link{example_df}}
}
\keyword{datasets}
