% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dictionary.R
\name{get_dictionary}
\alias{get_dictionary}
\title{Get Custom Dictionaries}
\usage{
get_dictionary(dictionary = NULL)
}
\arguments{
\item{dictionary}{A character string that specifies the dictionary to be
retrieved. It must be one of "global_burden_of_disease", "ch_cantons",
"us_states", "exiobase3", "gtap10". If NULL, the function will print the list
of available dictionaries. Default is NULL.}
}
\value{
If a valid dictionary is specified, the function will return that dictionary as a data.frame.
If an invalid dictionary or no dictionary is specified, the function will stop and throw an error message.
}
\description{
Download a custom dictionary to use in the \code{custom_dict} argument of \code{countrycode()}
}
\examples{
\dontrun{
cd <- get_dictionary("us_states")
countrycode::countrycode(c("MO", "MN"), origin = "state.abb", "state.name", custom_dict = cd)
}
}
