% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrop_hier_priors.R
\name{run_metrop_priors}
\alias{run_metrop_priors}
\title{Run the hierarchical Metropolis Hastings model to infer priors}
\usage{
run_metrop_priors(
  multi.dat,
  covar = FALSE,
  covar_vec = NULL,
  is_covar_categorical = FALSE,
  nits = 10000,
  thin = 1,
  posterior = FALSE,
  avg_pik = TRUE,
  avg_posterior = TRUE,
  pik = FALSE,
  alpha_mean = -10,
  alpha_sd = 0.5,
  beta_shape = 2,
  beta_scale = 2,
  gamma_shape = 2,
  gamma_scale = 2
)
}
\arguments{
\item{multi.dat}{matrix of bf values, rows=traits, named columns=("lBF.Ha","lBF.Hc","nsnps")}

\item{covar}{whether to include covariates}

\item{covar_vec}{vector of covariates}

\item{is_covar_categorical}{only two categories supported (default=FALSE) - Experimental}

\item{nits}{number of iterations}

\item{thin}{burnin}

\item{posterior}{default: FALSE, estimate posterior probabilities of the hypotheses}

\item{avg_pik}{default: FALSE, estimate the average of the pik}

\item{avg_posterior}{default: FALSE, estimate the average of the posterior probabilities of the hypotheses}

\item{pik}{default: FALSE, inferred prior probabilities}

\item{alpha_mean}{prior for the mean of  alpha}

\item{alpha_sd}{prior for the standard deviation of  alpha}

\item{beta_shape}{prior for the shape (gamma distibution) of beta}

\item{beta_scale}{prior for the scale of beta}

\item{gamma_shape}{prior for the shape (gamma distibution) of gamma}

\item{gamma_scale}{prior for the scale of gamma}
}
\value{
List containing the posterior distribution of the parameters alpha, beta, gamma (if covariate included) and the loglikelihood

if avg_posterior=TRUE matrix with average of all the posterior probabilities of Hn, Ha and Hc

if avg_pik=TRUE matrix with average of all the priors: pn, pa and pc

data, nits and thin contain the input data, number of iterations and burnin respectively specified for the hierarchical model
}
\description{
Run the hierarchical Metropolis Hastings model to infer priors
}
