% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alp.R
\name{alp}
\alias{alp}
\title{Associated Legendre Polynomials}
\usage{
alp(x, l = 0, m = 0)
}
\arguments{
\item{x}{real argument between -1 and +1, can be a vector}

\item{l}{degree of the polynomial (0,1,2,...); accurate to about 25}

\item{m}{order of the polynomial (-l,-l+1,...,l); for negative values the standard convention is used: if m>0, then P(x,l,-m) = P(x,l,m) (-1)^m*factorial(l-m)/factorial(l+m).}
}
\value{
Returns a vector with the same number of elements as \code{x}
}
\description{
Compute associated Legendre polynomials P_l^m(x), defined as the canonical solutions of the general Legendre equation. These polynomials are used, for instance, to compute the spherical harmonics.
}
\seealso{
\code{\link{sphericalharmonics}}
}
\author{
Danail Obreschkow
}
