% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equal.R
\name{is.equal}
\alias{is.equal}
\title{Numerical equality check}
\usage{
is.equal(x, ..., stoptext = NULL, eps = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{vector or array of values to compare}

\item{...}{optional additional values to compare}

\item{stoptext}{optional character string; if given, the routine stops if the values are not all equal and adds the character string to the error message}

\item{eps}{relative numerical tolerance}
}
\value{
Returns a logical value. TRUE means that all values of \code{x} are equal within the specified relative tolerance; also returns TRUE if all values are Inf or NA or NaN.
}
\description{
Checks if two or more numerical values are identical within a relative numerical tolerance
}
\examples{
# almost identical values
x = c(acos(1/sqrt(2)),pi/4)
print(x)
print(x[1]==x[2])
print(is.equal(x))

# various other examples
print(is.equal(1,2,3))
print(is.equal(1,NA,3))
print(is.equal(Inf,NA))
print(is.equal(NaN,NA))
print(is.equal(NaN,Inf))
print(is.equal(Inf,Inf,Inf))
print(is.equal(NA,NA))
print(is.equal(NaN,NaN))
print(is.equal(1.4,1.4))
print(is.equal(1.4,1.400000001))
print(is.equal(1.4,1.400000001,1.41))
print(is.equal(0,0,0,0))

}
\author{
Danail Obreschkow
}
