% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R
\name{remove_directory_cnt}
\alias{remove_directory_cnt}
\alias{remove_directory_cnt.ConnectorFS}
\title{Remove a directory}
\usage{
remove_directory_cnt(connector_object, name, ...)

\method{remove_directory_cnt}{ConnectorFS}(connector_object, name, ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{name}{\link{character} The name of the directory to remove}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to remove a directory for a connector.
Mostly relevant for file storage connectors.

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:delete]{fs::dir_delete()}} to remove a directory at the path of the connector.
}
}
\examples{
# Remove a directory from a file storage

folder <- withr::local_tempdir()
cnt <- connector_fs(folder)

cnt |>
  create_directory_cnt("new_folder")

cnt |>
  list_content_cnt(pattern = "new_folder")

cnt |>
  remove_directory_cnt("new_folder") |>
  list_content_cnt(pattern = "new_folder")

}
