% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{lock_content}
\alias{lock_content}
\alias{unlock_content}
\title{Lock or Unlock Content}
\usage{
lock_content(content, locked_message = "")

unlock_content(content)
}
\arguments{
\item{content}{An R6 content item}

\item{locked_message}{Optional. A custom message that is displayed by the
content item when locked. It is possible to format this message using Markdown.}
}
\value{
An R6 content item
}
\description{
Lock or unlock a content item. When content is locked, all processes are
terminated, rendering is disabled, and new bundles cannot be deployed.
}
\details{
\code{lock_content()} locks a content item with an optional message displayed to
visitors (supports Markdown).

\code{unlock_content()} unlocks a content item, reverting the effects of locking.
}
\examples{
\dontrun{
# Lock content with a message
client <- connect()
content <- content_item(client, "content-guid")
content <- lock_content(content, locked_message = "Ah ah ah! You didn't say the magic word!")

# Lock content without a message
content <- lock_content(content)

# Unlock content
content <- unlock_content(content)
}
}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_associations}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{permissions}},
\code{\link{search_content}()},
\code{\link{set_image_path}()},
\code{\link{set_integrations}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
