% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hearing.R
\name{cong_hearing}
\alias{cong_hearing}
\title{Request Hearing Information}
\usage{
cong_hearing(
  congress = NULL,
  chamber = NULL,
  number = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{chamber}{Chamber name. Can be \code{'house'}, \code{'senate'}, or \code{'nochamber'}.}

\item{number}{Jacket number for the hearing. Character (or numeric).}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Hearing Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_hearing()

cong_hearing(congress = 116)

cong_hearing(chamber = 'house')

cong_hearing(congress = 116, chamber = 'house')

cong_hearing(congress = 116, chamber = 'house', number = 41365)
\dontshow{\}) # examplesIf}
}
