% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/committee_print.R
\name{cong_committee_print}
\alias{cong_committee_print}
\title{Request Committee Print Information}
\usage{
cong_committee_print(
  congress = NULL,
  chamber = NULL,
  number = NULL,
  item = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{congress}{Congress number to search for. 81 or later are supported.}

\item{chamber}{Chamber name. Can be \code{'house'}, \code{'senate'}, or \code{'nochamber'}.}

\item{number}{Jacket number for the print. Character (or numeric).}

\item{item}{Information to request. Can be  \code{'text'}.}

\item{from_date}{start date for search, e.g. \code{'2022-04-01'}. Defaults to most recent.}

\item{to_date}{end date for search, e.g. \code{'2022-04-03'}. Defaults to most recent.}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request Committee Print Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_committee_print()

cong_committee_print(congress = 118)

cong_committee_print(chamber = 'house')

cong_committee_print(congress = 118, chamber = 'house')

cong_committee_print(congress = 117, chamber = 'house', number = '48144')

cong_committee_print(congress = 117, chamber = 'house', number = '48144', item = 'text')
\dontshow{\}) # examplesIf}
}
