% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrangeC.R
\name{arrangeC}
\alias{arrangeC}
\title{Make a list of variable pairings for condition selecting plots}
\usage{
arrangeC(data, method = "default")
}
\arguments{
\item{data}{A dataframe}

\item{method}{The character name for the method to use for measuring
bivariate dependency, passed to savingby2d.}
}
\value{
A list containing character vectors giving variable pairings.
}
\description{
This function arranges a number of variables in pairs, ordered
by their bivariate relationships. The goal is to discover which variable
pairings are most helpful in avoiding extrapolations when exploring the data
space. Variable pairs with strong bivariate dependencies (not necessarily
linear) are chosen first. The bivariate dependency is measured using
\code{savingby2d}. Each variable appears in the output only once.
}
\details{
If \code{data} is so big as to make \code{arrangeC} very slow, a
  random sample of rows is used instead. The bivariate dependency measures
  are rough, and the ordering algorithm is a simple greedy one, so it is not
  worth allowing it too much time.
}
\references{
O'Connell M, Hurley CB and Domijan K (2017). ``Conditional
  Visualization for Statistical Models: An Introduction to the
  \strong{condvis} Package in R.''\emph{Journal of Statistical Software},
  \strong{81}(5), pp. 1-20. <URL:http://dx.doi.org/10.18637/jss.v081.i05>.
}
