% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusWilcox.R
\name{clusWilcox.test}
\alias{clusWilcox.test}
\alias{clusWilcox.test.default}
\alias{clusWilcox.test.formula}
\title{Wilcoxon Rank Sum and Signed Rank Test for Clustered Data}
\usage{
clusWilcox.test(x, ...)

\method{clusWilcox.test}{formula}(formula, data = parent.frame(),
  subset = NULL, na.action = na.omit, alternative = c("two.sided", "less",
  "greater"), mu = 0, paired = FALSE, exact = FALSE, method = c("rgl",
  "ds"), ...)

\method{clusWilcox.test}{default}(x, y = NULL, cluster = NULL,
  group = NULL, stratum = NULL, data = NULL,
  alternative = c("two.sided", "less", "greater"), mu = 0, paired = FALSE,
  exact = FALSE, method = c("rgl", "ds"), ...)
}
\arguments{
\item{x}{A numeric vector of data values or a formula. Non-finite (e.g.,
infinite or missing) values will be omitted}

\item{...}{Further arguments to be passed to or from methods}

\item{formula}{A formula of the form \code{lhs ~ rhs} where the
\code{lhs} is the observed values and
the \code{rhs} of the form group + \code{cluster}(x1) +
\code{stratum}(x2) for clustered rank sum test, where
\code{x1} and \code{x2} are cluster id and stratum id in the
data.  For clustered signed rank test, only \code{cluster}(x1)
should appear on the right hand side.}

\item{data}{An optional matrix or dataframe of data used in the
formula.}

\item{subset}{An optional vector specifying a subset of
observations to be used.}

\item{na.action}{A function which indicates what should happen
when the data contain NAs. Defaults to getOption("na.action").}

\item{alternative}{A character string specifying the alternative
hypothesis, must be one of \code{"two sided"} (default),
\code{"greater"} or \code{"less"}. You can specify just the
initial letter}

\item{mu}{A number specifying an optional parameter used to form
the null hypothesis. See 'Details'}

\item{paired}{A logical indicating whether you want a paired test}

\item{exact}{A logical indicating whether an exact p-value should
be computed. Not recommended currently.}

\item{method}{A character string specifying the method of
clustered wilcoxon rank test used, must be one of \code{"rgl"}
or \code{"ds"}}

\item{y}{An optional numeric vector of data values: as with
\code{x} non-finite values will be omitted}

\item{cluster}{A optional numeric vector of cluster id. Does not
apply to the formula interface}

\item{group}{A optional numeric vector of treatment id. Does not
apply to the formula interface}

\item{stratum}{A opptional numeric vector of stratum id. Only
applies for the \code{"rgl"} method. Does not apply to the
formula interface.}
}
\value{
A list with class \code{"ctest"}.

\item{Rstat}{The value of the rank statistic with a name discribing it}
\item{ERstat}{The expectation of the rank statistic}
\item{VRstat}{The variance of the rank statistic}
\item{statistic}{The value of the test statistic}
\item{p.value}{The p-value for the test}
\item{null.value}{The location parameter \code{mu}}
\item{method}{The type of test applied}
\item{data.name}{A character string giving the names of the data}
\item{balance}{A logical indicating whether the data are balanced}
\item{n.group}{Number of treatment, is returned when there are more than 2 treatment groups}
\item{df}{Degrees of freedom of chi-square distribution, is returned when there are more than 2 treatment groups}
}
\description{
Performs one-sample and two-sample Wilcoxon test for clutered data
on vectors of data.
}
\details{
The formula interface is to both clustered signed rank
    test and clustered rank sum test.

Given the cluster id, if both \code{x} and \code{y} are provided
or only \code{x} is provided and \code{paired} is \code{TRUE}, a
clustered Wilcoxon signed rank test of the null hypothesis that
the distribution of \code{x - y} or of \code{x} is symmetric about
\code{mu} is performed.

Otherwise, if only \code{x} is given and \code{paired} is
\code{FALSE}, a Wilcoxon rank sum test is carried out. In this
case, the \code{group} variable is required. If the \code{method}
is \code{"rgl"} (default), the null hypothesis is that the
distributions of values from the two groups differ by a location
shift of \code{mu} and the alternative is that they differ by some
other location shift. If the \code{method} is \code{"ds"}, when
the \code{group} has 2 levels, the null and hypothesis are the
same as for \code{"rgl"} test; when \code{group} has more than 2
levels, the null hypothesis is that the locations
are the same for data in all groups and the alternative is that
they are not all the same.


If \code{cluster} is not provided, the default is that there is no
clutering in the data. Both \code{"rgl"} and \code{"ds"} method
support balanced and unbalanced data (cluster size is identical or
varied) and individual level and cluster level treatment assignment.

If \code{method} is \code{"rgl"}, then a strafication variable,
\code{stratum}, is allowed for the clustered Wilcoxon rank sum
test.

The exact test is still under development and is only available
for ranksum test when treatment is assigned at cluster level and
signed rank test for \code{rgl} method and can be applied when
number of cluster is small (under 50). It will be slow if number
of cluster is too large.

There is also a formula interface for both tests. For details look
at the examples.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: \code{S3} method for class 'formula'

\item \code{default}: Default \code{S3} method.
}}
\note{
Exact tests are not recommended in the current version of package.
}
\examples{
## Clustered signed rank test using RGL method.
data(crsd)
clusWilcox.test(z, cluster = id, data = crsd, paired = TRUE)
## or
clusWilcox.test(z ~ cluster(id), data = crsd, paired = TRUE)
\dontrun{clusWilcox.test(z, cluster = id, data = crsd)
## Default is rank sum test. The group variable is required.}
## Clustered rank sum test using RGL method.
data(crd)
clusWilcox.test(z ~ group + cluster(id), data = crd)
## or
clusWilcox.test(z, cluster = id, group = group, data = crd)
}
\author{
Yujing Jiang
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling T. Lee (2006)
\emph{The Wilcoxon Signed Rank Test for Paired Comparisons of
 Clustered Data}. Biometrics, \bold{62}, 185-192.

Bernard Rosner, Robert J. Glynn, Mei-Ling T. Lee (2003)
\emph{Incorporation of Clustering Effects for the Wilcoxon Rank
Sum Test: A Large-Sample Approach}. Biometrics, \bold{59}, 1089-1098.

Bernard Rosner, Robert J. Glynn, Mei-Ling T. Lee (2006)
\emph{Extension of the Rank Sum Test for Clustered Data: 
Two-Group Comparisons with Group}. Biometrics, \bold{62}, 1251-1259.

Somnath Datta, Glen A. Satten (2005) \emph{Rank-Sum Tests for Clustered Data}.
Journal of the American Statistical Association, \bold{100}, 908-915.

Somath Datta, Glen A. Satten (2008) \emph{A Signed-Rank test for Clustered Data}.
Biometric, \bold{64}, 501-507.
}

